/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.util.identity;

import com.terraforged.mod.featuremanager.util.identity.Identifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class IdentityCache<T>
implements Function<T, Identifier> {
    private final Function<T, Identifier> identifierFunction;
    private final Map<T, Identifier> cache = new ConcurrentHashMap<T, Identifier>();

    public IdentityCache(Function<T, Identifier> identifierFunction) {
        this.identifierFunction = identifierFunction;
    }

    @Override
    public Identifier apply(T t) {
        return this.cache.computeIfAbsent(t, this.identifierFunction);
    }
}

